# Emulating an USB CDROM on STM32F103C8 #

There are four steps to implement a tiny USB CDROM on STM32F103C8.

**STEP1: Hardware Design**

I choosed the **Bluepill** board as the main controller, which has two SPI ports to be used to connect serial flash or TF card.  I configured the SPI2 as a master port with 8bit data size.  PB12 was used as the CS signal generator which was controlled by the firmware. The SPI1 was configured as well but unused in this project. I connected a serial flash chip to the Bluepill as the DISC. Unfortunately I just had some obsolete tiny flash chips  (AT45DB041B). That means I had to build a tiny ISO9660 disc image file which could be burnt into this flash chip.

**STEP2: Firmware Generate**

Generate Firmware source code with STM32CubeMX:

- Use HSE oscillator with 8MHz crystal resonator. LSE oscillator is disabled.
- Use Serial Wire debug port.
- Configure SPI2 as Full Duplex Master port. Data size is 8bit.
- Active the USB Device.
- Configure the USB Middleware, Mass Storage Class.
- Select PLLCLK (72MHz) as the SYSCLK. HCLK is 72MHz and USB Clock is 48MHz.

**STEP3: Coding and Compile**

- Build a driver for the serial flash chip. (spiflash.c)

  - Get the ID of chip. (I was trying to support some generic flash chip, such as W25X32, etc.)
  - Initialize the flash chip.
  - Get maximum sectors of DISC.
  - Program/Read a page.
  - Program/Read a Sector of DISC.
  - Connect flash chip driver to the USB class. (usbd_storage_if.c)

  Some codes (SELECT/DESELECT/SPI_Xxx) are derived from [eziya's STM32_SPI_SDCARD project](https://github.com/eziya/STM32_SPI_SDCARD).

- Process some extra SCSI requests which were not supported by STM32CubeMX.
  - READ TOC/PMA/ATIP (0x43)
  - GET CONFIGURATION (0x46)
  - GET EVENT/STATUS NOTIFICATION (0x4A)
  - READ DISC INFORMATION (0x51)

- Patch the source code generated by STM32CuteMX.
  - INQUIRY (0x12)
    - Declare a CDROM in response data.
    - Support the PAGE CODE. (I'm not sure if it is nessary or not.)
  - the function "MSC_BOT_CBW_Decode"
    - It didn't send CSW when the func SCSI_ProcessCmd returned -1.
- Implement some custom SCSI commands
  - GET FLASH CHIPID (0xFF)
  - BURN DISC IMAGE (0xFE)

I compiled the source code with GCC (arm_none_eabi) under EmBitz and debug with my brand new homemade [CMSIS-DAP JTAG probe](https://github.com/GenieKits/CMSIS-DAP_on_STM32_with_EmBitz). ;)

**STEP4: Build and Burn ISO9660 disc image**

I chose [Folder2Iso](https://www.trustfm.net/software/utilities/Folder2Iso.php) to generate a ISO9660 disc image file.  Because of the small capacity of AT45DB041B, I had to build a tool to trim the image file. Please refer to iso9660 project in Win32 directory. Some source code comes from [gootqt's blog: ISO9660文件系统分析](https://blog.csdn.net/GoodQt/article/details/17202109).

The disc burn tool (MSC_Test project in Win32 directory) is a little bit tricky. I used the func "GetMscDeviceContext" to get the pathname of the USB CDROM. If you have another USB CDROM which has been connected to the host, please unplug it or check the strings of manufacturer/product retrieved via INQUIRY command. If you  try to use VID/PID to detect the CDROM, please refer to [this webpage on stackoverflow.com](https://stackoverflow.com/questions/4065473/find-and-eject-a-usb-device-based-on-its-vid-pid). I left some source codes (the funcs "GetDrivesDevInstByDeviceNumber" and "matchDevInstToUsbDevice") which was from this webpage in my project. 



